/*! \file tlk_sclk_api_types.h 
**********************************************************************************
*Title:                         Discretix Secured Clock Toolkit header file
*
* Filename:                     tlk_sclk_api_types.h 
*
* Project, Target, subsystem:   Toolkit, Secured Clock
* 
* Created:                      10.09.2008
*
* Modified:                     10.09.2008
*
* \Author                       Ira Boguslavsky
*
* \Remarks
*           Copyright (C) 2008 by Discretix Technologies Ltd. All Rights reserved.
**********************************************************************************/
#ifndef _TLK_SCLK_API_TYPES_H_
#define  _TLK_SCLK_API_TYPES_H_

#include "DX_VOS_TimeUtils.h"

#include "tlk_sclk_api_defs.h"
#include "tlk_sclk_api_types.h"

#ifdef __cplusplus
extern "C" {
#endif
typedef struct 
{
    DxBool_t        isActive;
    DxBool_t        startNotAfterReset;
}TLK_SCLK_APIRuntimeVars_t;

typedef union
{
    DxGeneralizedTime_t genTimeFormat;
    DxUint32_t          secondsSince;
}TLK_SCLK_Time_t;


typedef DxByte_t    TLK_SCLK_Cookie_t[TLK_SCLK_TAMPER_EVIDENCE_COOKIE_SIZE_IN_BYTES];

typedef DxByte_t    TLK_SCLK_ApplicationId_t[TLK_SCLK_APPLICATION_ID_SIZE_IN_BYTES];

typedef DxUint32_t  TLK_SCLK_MacBuffer_t[TLK_SCLK_MAC_LENGTH_IN_BYTES];

typedef enum
{
    TLK_SCLK_WORLD_READABLE     = 0,
    TLK_SCLK_PRIVATE_READABLE   = 1,

    TLK_SCLK_READ_PERMISSION_LAST    = 0x7FFFFFFF
}TLK_SCLK_ReadPermission_t;

typedef struct
{
    DxUint32_t                  token;                                          /*!<This is an indication if other application updated the descriptor or not **/
    DxBool_t                    unsetFlag;                                      /*!<The "unset" flag marks the master clock's current value as undependable (requiring revalidation).**/
    TLK_SCLK_Cookie_t           cookie;                                         /*!<Tamper Evidence Cookie**/
    DxTime_t                    clockDriftRateIn0_1PPM;                         /*!<The maximum drift of the platform's master clock (measured in units of 0.1 ppm (parts-per-million)).**/
    DxTime_t                    clockParametersUpdatePeriodInSec;               /*!<Time between toolkit's periodic updates of its parameter block to system NVM; parameter block updates are required for anti-rollback protection when the master clock may be settable by outside parties.**/
    DxTime_t                    lastParametersUpdateTimeInSec;                  /*!<Last parameters update period time **/
}TLK_SCLK_MasterClockDescriptor_t;


typedef struct
{
    TLK_SCLK_ApplicationId_t    appId;                                          /*!<The application id of secure service that created the clock  Optional to user. NULL means, that user does not send the ID.**/
    TLK_SCLK_ReadPermission_t   readPermission;                                 /*!<Allows to applications other than owner to read the secured service clock.**/
    DxTime_t                    offsetInSeconds;                                /*!<Offset (in seconds) between this secure clock and the time base**/
    TLK_SCLK_Cookie_t           cookie;                                         /*!<Expected value of tamper evidence "cookie".**/
    DxTime_t                    maxAllowedDriftIn0_1Seconds;                    /*!<Maximum allowed drift for this clock (in units of 0.1 seconds). **/
    DxTime_t                    clockValidityLimitInSeconds;                    /*!<When the clock value reaches this limit, it will be flagged as "requiring revalidation".**/
    DxTime_t                    maxRevalidationPeriodInSeconds;                 /*!<Once the clock is at (validity limit + revalidation period), it reverts to an "unset" state.**/
    TLK_SCLK_MacBuffer_t        mac;                                            /*!<MAC value (for authentication)**/

}TLK_SCLK_ServiceClockDescriptor_t;

typedef union
{
    DxTime_t                    secondsSinceFormat;                             /*!<Number of seconds since 01/01/2008**/
    DxGeneralizedTime_t         dateTimeFormat;                                 /*!<Date/time fields format**/
}TLK_SCLK_ServiceClockTime_t;

typedef enum
{
    TLK_SCLK_SECONDS_SINCE_FORMAT       = 0,
    TLK_SCLK_DATE_TIME_FORMAT           = 1,

    TLK_SCLK_TIME_FORMAT_LAST           = 0x7FFFFFFF
}TLK_SCLK_TimeFormat_t;

typedef enum
{
    TLK_SCLK_STATUS_VALID               = 0,
    TLK_SCLK_STATUS_UNSET_INVALID       = 1,
    TLK_SCLK_STATUS_MUST_REVALIDATE     = 2,

    TLK_SCLK_READ_STATUS_LAST           = 0x7FFFFFFF
}TLK_SCLK_ReadStatus_t;

typedef enum
{
    TLK_SCLK_UNSET_FLAG_UNSET           = 0,
    TLK_SCLK_UNSET_FLAG_SET             = 1,

    TLK_SCLK_UNSET_FLAG_LAST            = 0x7FFFFFFF
}TLK_SCLK_UnsetFlag_t;


typedef DxTime_t TLK_SCLK_TimeInSeconds_t;

#ifdef __cplusplus
}
#endif /*extern "C"*/

#endif /*_TLK_SCLK_API_TYPES_H_*/
